<?php
// yetkiler/index.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../inc/permissions.php';

if (!$isAdmin) { header("Location: " . url('/panel/index.php')); exit; }

$modules = modules_list();
$ok = $err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $userId = (int)($_POST['user_id'] ?? 0);
  $sel = $_POST['modules'] ?? [];
  if ($userId <= 0) {
    $err = "Kullanıcı seçmelisin.";
  } else {
    // sadece tanımlı modüller
    $sel = array_values(array_intersect(array_keys($modules), is_array($sel) ? $sel : []));
    $pdo->beginTransaction();
    try {
      $pdo->prepare("DELETE FROM kullanici_yetkileri WHERE kullanici_id=?")->execute([$userId]);
      if ($sel) {
        $ins = $pdo->prepare("INSERT INTO kullanici_yetkileri (kullanici_id, modul_kodu) VALUES (?,?)");
        foreach ($sel as $m) $ins->execute([$userId, $m]);
      }
      $pdo->commit();
      $ok = "Yetkiler kaydedildi.";
    } catch (Throwable $e) {
      $pdo->rollBack();
      $err = "Hata: " . h($e->getMessage());
    }
  }
}

$users = $pdo->query("SELECT id, ad_soyad, kullanici_adi, rol, aktif FROM kullanicilar ORDER BY rol DESC, ad_soyad ASC")->fetchAll();

$pageTitle = 'Yetkiler';
include __DIR__ . '/../inc/header.php';
include __DIR__ . '/../inc/navbar.php';
?>
<div class="container py-4">
  <h4 class="fw-bold mb-3"><i class="bi bi-shield-lock me-1"></i> Kullanıcı Yetkileri</h4>

  <?php if ($err): ?><div class="alert alert-danger"><?= $err ?></div><?php endif; ?>
  <?php if ($ok): ?><div class="alert alert-success"><?= h($ok) ?></div><?php endif; ?>

  <div class="card shadow-sm border-0">
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-12 col-lg-5">
          <label class="form-label">Kullanıcı Seç</label>
          <select class="form-select" name="user_id" required>
            <option value="">Seç...</option>
            <?php foreach ($users as $u): ?>
              <option value="<?= (int)$u['id'] ?>">
                <?= h($u['ad_soyad']) ?> (<?= h($u['kullanici_adi']) ?>) - <?= h($u['rol']) ?>
                <?= ((int)$u['aktif']===1 ? '' : ' [PASİF]') ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-12 col-lg-7">
          <label class="form-label">Modüller</label>
          <div class="d-flex flex-wrap gap-2">
            <?php foreach ($modules as $code => $label): ?>
              <label class="btn btn-outline-primary btn-sm">
                <input class="form-check-input me-1" type="checkbox" name="modules[]" value="<?= h($code) ?>">
                <?= h($label) ?>
              </label>
            <?php endforeach; ?>
          </div>
          <div class="form-text">Admin zaten her şeyi görür; personel için buradan modül açarsın.</div>
        </div>

        <div class="col-12">
          <button class="btn btn-success"><i class="bi bi-save2 me-1"></i> Kaydet</button>
          <a class="btn btn-outline-secondary" href="<?= h(url('/panel/index.php')) ?>">Panele Dön</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../inc/footer.php'; ?>
