-- mini muhasebe takip - schema.sql
-- MySQL / MariaDB

CREATE TABLE IF NOT EXISTS kullanicilar (
  id INT AUTO_INCREMENT PRIMARY KEY,
  ad_soyad VARCHAR(120) NOT NULL,
  kullanici_adi VARCHAR(60) NOT NULL UNIQUE,
  sifre VARCHAR(255) NOT NULL,
  rol ENUM('admin','personel') NOT NULL DEFAULT 'personel',
  aktif TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS projeler (
  id INT AUTO_INCREMENT PRIMARY KEY,
  yil INT NOT NULL,
  proje_adi VARCHAR(160) NOT NULL,
  olusturan_kullanici_id INT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX (yil),
  CONSTRAINT fk_proje_user FOREIGN KEY (olusturan_kullanici_id) REFERENCES kullanicilar(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS proje_fatura_kayitlari (
  id INT AUTO_INCREMENT PRIMARY KEY,
  proje_id INT NOT NULL,
  fatura_adi VARCHAR(200) NOT NULL,
  fatura_tipi ENUM('Satis','Alis') NOT NULL,
  tarih DATE NOT NULL,
  birim_tipi ENUM('Adet','Koli','Paket','Kg') NOT NULL,
  birim_miktar DECIMAL(12,2) NOT NULL DEFAULT 1,
  birim_fiyat DECIMAL(14,2) NOT NULL DEFAULT 0,     -- birim fiyat (KDV hariç)
  kdv_haric_tutar DECIMAL(14,2) NOT NULL DEFAULT 0,  -- miktar*birim_fiyat
  kdv_oran TINYINT NOT NULL DEFAULT 20,              -- 0/1/10/20
  genel_toplam DECIMAL(14,2) NOT NULL DEFAULT 0,     -- kdv dahil
  olusturan_kullanici_id INT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX (proje_id),
  INDEX (tarih),
  CONSTRAINT fk_kayit_proje FOREIGN KEY (proje_id) REFERENCES projeler(id) ON DELETE CASCADE,
  CONSTRAINT fk_kayit_user FOREIGN KEY (olusturan_kullanici_id) REFERENCES kullanicilar(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Admin kullanıcı (şifre: 1234) -> md5
INSERT IGNORE INTO kullanicilar (ad_soyad, kullanici_adi, sifre, rol, aktif)
VALUES ('Admin', 'admin', MD5('1234'), 'admin', 1);
