<?php
// projeler/olustur.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';

$yil = (int)($_POST['yil'] ?? 0);
$projeAdi = trim((string)($_POST['proje_adi'] ?? ''));

if ($yil < 2000 || $yil > 2100) {
  header("Location: " . url('/panel/index.php'));
  exit;
}

if ($projeAdi === '') {
  header("Location: " . url('/panel/index.php'));
  exit;
}

if (mb_strlen($projeAdi, 'UTF-8') > 160) {
  $projeAdi = mb_substr($projeAdi, 0, 160, 'UTF-8');
}

$stmt = $pdo->prepare("INSERT INTO projeler (yil, proje_adi, olusturan_kullanici_id) VALUES (?,?,?)");
$stmt->execute([$yil, $projeAdi, (int)$_SESSION['id']]);

$pid = (int)$pdo->lastInsertId();
header("Location: " . url('/projeler/detay.php?id=' . $pid));
exit;
