<?php
// projeler/detay.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';

$projeId = (int)($_GET['id'] ?? 0);
if ($projeId <= 0) { header("Location: ../panel/index.php"); exit; }

$proje = $pdo->prepare("SELECT * FROM projeler WHERE id=? LIMIT 1");
$proje->execute([$projeId]);
$P = $proje->fetch();
if (!$P) { header("Location: ../panel/index.php"); exit; }

$err = '';
$ok  = '';

/* Çoklu satır kaydet (Birim Fiyatlı) */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $fatura_adi   = $_POST['fatura_adi'] ?? [];
  $fatura_tipi  = $_POST['fatura_tipi'] ?? [];
  $tarih        = $_POST['tarih'] ?? [];
  $birim_tipi   = $_POST['birim_tipi'] ?? [];
  $birim_miktar = $_POST['birim_miktar'] ?? [];
  $birim_fiyat  = $_POST['birim_fiyat'] ?? [];
  $kdv_oran     = $_POST['kdv_oran'] ?? [];

  $count = is_array($fatura_adi) ? count($fatura_adi) : 0;

  if ($count < 1) {
    $err = "En az 1 satır eklemelisin.";
  } else {
    $pdo->beginTransaction();
    try {
      $ins = $pdo->prepare("
        INSERT INTO proje_fatura_kayitlari
        (proje_id, fatura_adi, fatura_tipi, tarih, birim_tipi, birim_miktar, birim_fiyat, kdv_haric_tutar, kdv_oran, genel_toplam, olusturan_kullanici_id)
        VALUES (?,?,?,?,?,?,?,?,?,?,?)
      ");

      $saved = 0;

      for ($i=0; $i<$count; $i++) {
        $fa = trim((string)($fatura_adi[$i] ?? ''));
        $ft = (string)($fatura_tipi[$i] ?? '');
        $tr = (string)($tarih[$i] ?? '');
        $bt = (string)($birim_tipi[$i] ?? '');

        $bm = (float)($birim_miktar[$i] ?? 0);
        $bf = (float)($birim_fiyat[$i] ?? 0);
        $ko = (int)($kdv_oran[$i] ?? 0);

        if ($fa === '' || !in_array($ft, ['Satis','Alis'], true) || $tr === '') continue;
        if (!in_array($bt, ['Adet','Koli','Paket','Kg'], true)) continue;
        if (!in_array($ko, [0,1,10,20], true)) $ko = 20;

        if ($bm <= 0) $bm = 1;
        if ($bf < 0)  $bf = 0;

        // KDV hariç tutar = miktar * birim fiyat
        $kdvHaric = $bm * $bf;

        // Genel = KDV hariç + KDV
        $genel = $kdvHaric + ($kdvHaric * ($ko / 100));

        $ins->execute([
          $projeId,
          $fa,
          $ft,
          $tr,
          $bt,
          number_format($bm, 2, '.', ''),
          number_format($bf, 2, '.', ''),
          number_format($kdvHaric, 2, '.', ''),
          $ko,
          number_format($genel, 2, '.', ''),
          (int)$_SESSION['id']
        ]);

        $saved++;
      }

      $pdo->commit();
      $ok = "{$saved} satır kaydedildi.";
    } catch (Throwable $e) {
      $pdo->rollBack();
      $err = "Kayıt hatası: " . h($e->getMessage());
    }
  }
}

/* Liste */
$rowsStmt = $pdo->prepare("SELECT * FROM proje_fatura_kayitlari WHERE proje_id=? ORDER BY id DESC");
$rowsStmt->execute([$projeId]);
$ROWS = $rowsStmt->fetchAll();

$pageTitle = 'Proje Detay';
include __DIR__ . '/../inc/header.php';
include __DIR__ . '/../inc/navbar.php';
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
    <div>
      <h4 class="fw-bold mb-0">📁 <?= h($P['proje_adi']) ?> (<?= (int)$P['yil'] ?>)</h4>
      <div class="text-secondary small">Satır satır fatura kaydı gir (Birim Fiyatlı).</div>
    </div>
    <div class="d-flex gap-2 flex-wrap">
      <a class="btn btn-outline-secondary" href="../panel/index.php"><i class="bi bi-arrow-left me-1"></i> Panele Dön</a>
    </div>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><i class="bi bi-x-circle me-1"></i><?= $err ?></div><?php endif; ?>
  <?php if ($ok): ?><div class="alert alert-success"><i class="bi bi-check-circle me-1"></i><?= h($ok) ?></div><?php endif; ?>

  <!-- Satır Ekleme (Çoklu) -->
  <div class="card shadow-sm border-0 mb-3">
    <div class="card-header bg-white fw-semibold d-flex align-items-center justify-content-between flex-wrap gap-2">
      <span><i class="bi bi-plus-circle me-1"></i> Yeni Satırlar</span>
      <div class="d-flex gap-2">
        <button type="button" class="btn btn-sm btn-outline-primary" onclick="addRow()">
          <i class="bi bi-plus-lg me-1"></i> Satır Ekle
        </button>
        <button type="button" class="btn btn-sm btn-outline-danger" onclick="clearRows()">
          <i class="bi bi-trash me-1"></i> Temizle
        </button>
      </div>
    </div>

    <div class="card-body">
      <form method="post" id="frmRows">
        <div class="table-responsive">
          <table class="table table-bordered align-middle text-center" id="entryTable">
            <thead class="table-dark">
              <tr>
                <th>Fatura Adı</th>
                <th>Tip</th>
                <th>Tarih</th>
                <th>Birim Tipi</th>
                <th>Birim</th>
                <th>Birim Fiyat (KDV Hariç)</th>
                <th>KDV Hariç Tutar</th>
                <th>KDV</th>
                <th>Genel Toplam</th>
                <th>Sil</th>
              </tr>
            </thead>
            <tbody id="entryBody"></tbody>
          </table>
        </div>

        <div class="d-flex justify-content-end gap-2 flex-wrap">
          <button class="btn btn-success" type="submit">
            <i class="bi bi-save2 me-1"></i> Kaydet
          </button>
        </div>
      </form>
    </div>
  </div>

  <!-- Kayıtlar Listesi -->
  <div class="card shadow-sm border-0">
    <div class="card-header bg-white fw-semibold">
      <i class="bi bi-list-check me-1"></i> Kayıtlar
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-center">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>Fatura Adı</th>
              <th>Tip</th>
              <th>Tarih</th>
              <th>Birim Tipi</th>
              <th>Birim</th>
              <th>Birim Fiyat</th>
              <th>KDV Hariç</th>
              <th>KDV</th>
              <th>Genel</th>
              <th>İşlem</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!$ROWS): ?>
              <tr><td colspan="11" class="text-secondary">Kayıt yok.</td></tr>
            <?php else: foreach ($ROWS as $r): ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td class="text-start fw-semibold"><?= h($r['fatura_adi']) ?></td>
                <td><?= h($r['fatura_tipi']) ?></td>
                <td><?= h($r['tarih']) ?></td>
                <td><?= h($r['birim_tipi']) ?></td>
                <td><?= number_format((float)$r['birim_miktar'], 2, ',', '.') ?></td>
                <td><?= number_format((float)($r['birim_fiyat'] ?? 0), 2, ',', '.') ?></td>
                <td><?= number_format((float)$r['kdv_haric_tutar'], 2, ',', '.') ?></td>
                <td>%<?= (int)$r['kdv_oran'] ?></td>
                <td class="fw-bold"><?= number_format((float)$r['genel_toplam'], 2, ',', '.') ?></td>
                <td>
                  <?php if ($isAdmin): ?>
                    <a class="btn btn-danger btn-sm"
                       href="kayit_sil.php?proje_id=<?= (int)$projeId ?>&id=<?= (int)$r['id'] ?>"
                       onclick="return confirm('Bu satırı silmek istiyor musun?');">
                      <i class="bi bi-trash"></i>
                    </a>
                  <?php else: ?>
                    <span class="text-secondary small">Yetki yok</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
function money(n){
  n = isFinite(n) ? n : 0;
  return Math.round(n * 100) / 100;
}
function computeRow(tr){
  const miktar = parseFloat(tr.querySelector('[name="birim_miktar[]"]').value || 0);
  const fiyat  = parseFloat(tr.querySelector('[name="birim_fiyat[]"]').value || 0);
  const kdv    = parseInt(tr.querySelector('[name="kdv_oran[]"]').value || 0, 10);

  const kdvHaric = money(miktar * fiyat);
  const genel = money(kdvHaric + (kdvHaric * (kdv/100)));

  tr.querySelector('.kdv_haric_view').value = kdvHaric.toFixed(2);
  tr.querySelector('.genel_toplam_view').value = genel.toFixed(2);
}
function addRow(){
  const tb = document.getElementById('entryBody');
  const tr = document.createElement('tr');

  tr.innerHTML = `
    <td><input class="form-control" name="fatura_adi[]" required></td>
    <td>
      <select class="form-select" name="fatura_tipi[]" required>
        <option value="Satis">Satış</option>
        <option value="Alis">Alış</option>
      </select>
    </td>
    <td><input class="form-control" type="date" name="tarih[]" value="<?= date('Y-m-d') ?>" required></td>
    <td>
      <select class="form-select" name="birim_tipi[]" required>
        <option>Adet</option><option>Koli</option><option>Paket</option><option>Kg</option>
      </select>
    </td>
    <td><input class="form-control" type="number" step="0.01" min="0" name="birim_miktar[]" value="1"></td>
    <td><input class="form-control" type="number" step="0.01" min="0" name="birim_fiyat[]" value="0"></td>
    <td><input class="form-control kdv_haric_view" type="text" value="0.00" readonly></td>
    <td>
      <select class="form-select" name="kdv_oran[]">
        <option value="0">0</option>
        <option value="1">1</option>
        <option value="10">10</option>
        <option value="20" selected>20</option>
      </select>
    </td>
    <td><input class="form-control genel_toplam_view" type="text" value="0.00" readonly></td>
    <td>
      <button type="button" class="btn btn-outline-danger btn-sm" onclick="this.closest('tr').remove()">
        <i class="bi bi-x-lg"></i>
      </button>
    </td>
  `;

  tr.querySelectorAll('input,select').forEach(el => {
    el.addEventListener('input', () => computeRow(tr));
    el.addEventListener('change', () => computeRow(tr));
  });

  tb.appendChild(tr);
  computeRow(tr);
}
function clearRows(){
  document.getElementById('entryBody').innerHTML = '';
}
document.addEventListener('DOMContentLoaded', () => {
  addRow();
});
</script>

<?php include __DIR__ . '/../inc/footer.php'; ?>
