<?php
// personeller/proje_maas.php (FULL - Satırda Ay + Canlı Toplam + Çoklu Satır Kaydı)
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../inc/permissions.php';

$uid = (int)($_SESSION['id'] ?? 0);
if (!has_module($pdo, $uid, $isAdmin, 'personeller')) {
  header("Location: " . url('/panel/index.php'));
  exit;
}

$err = $ok = '';

$projeler = $pdo->query("SELECT id, yil, proje_adi FROM projeler ORDER BY id DESC")->fetchAll();
$personeller = $pdo->query("SELECT id, ad_soyad FROM personeller WHERE aktif=1 ORDER BY ad_soyad ASC")->fetchAll();

// Filtreler (Ay üstten yok)
$proje_id = (int)($_GET['proje_id'] ?? 0);
$yil      = (int)($_GET['yil'] ?? (int)date('Y'));
if ($yil < 2000 || $yil > 2100) $yil = (int)date('Y');

// Kaydet / Sil
if ($isAdmin && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $proje_id = (int)($_POST['proje_id'] ?? 0);
  $yil      = (int)($_POST['yil'] ?? (int)date('Y'));
  if ($yil < 2000 || $yil > 2100) $yil = (int)date('Y');

  $row_id      = $_POST['row_id'] ?? [];
  $personel_id = $_POST['personel_id'] ?? [];
  $ay_arr      = $_POST['ay'] ?? [];
  $brut        = $_POST['brut_maas'] ?? [];
  $net         = $_POST['net_maas'] ?? [];
  $sgk         = $_POST['sgk_primi'] ?? [];
  $acik        = $_POST['aciklama'] ?? [];

  // Silinecekler
  $deleted_ids_raw = (string)($_POST['deleted_ids'] ?? '');
  $deleted_ids = [];
  if (trim($deleted_ids_raw) !== '') {
    foreach (explode(',', $deleted_ids_raw) as $x) {
      $x = (int)trim($x);
      if ($x > 0) $deleted_ids[] = $x;
    }
    $deleted_ids = array_values(array_unique($deleted_ids));
  }

  if ($proje_id <= 0) {
    $err = "Proje seçmelisin.";
  } else {
    $pdo->beginTransaction();
    try {
      // 1) Sil (id bazlı)
      if ($deleted_ids) {
        $in = implode(',', array_fill(0, count($deleted_ids), '?'));
        $params = array_merge([$proje_id, $yil], $deleted_ids);
        $pdo->prepare("DELETE FROM proje_maas_kayitlari WHERE proje_id=? AND yil=? AND id IN ($in)")
            ->execute($params);
      }

      // 2) UPDATE / INSERT (UPSERT YOK → çoklu satır destek)
      $stIns = $pdo->prepare("
        INSERT INTO proje_maas_kayitlari
          (proje_id, yil, ay, personel_id, brut_maas, net_maas, sgk_primi, aciklama, olusturan_kullanici_id)
        VALUES (?,?,?,?,?,?,?,?,?)
      ");

      $stUpd = $pdo->prepare("
        UPDATE proje_maas_kayitlari
        SET ay=?, personel_id=?, brut_maas=?, net_maas=?, sgk_primi=?, aciklama=?
        WHERE id=? AND proje_id=? AND yil=?
      ");

      $n = is_array($personel_id) ? count($personel_id) : 0;
      $saved = 0;

      for ($i=0; $i<$n; $i++) {
        $rid = (int)($row_id[$i] ?? 0);
        $pid = (int)($personel_id[$i] ?? 0);
        $ay  = (int)($ay_arr[$i] ?? 0);

        if ($pid <= 0) continue;
        if ($ay < 1 || $ay > 12) continue;

        $b   = (float)($brut[$i] ?? 0);
        $nma = (float)($net[$i] ?? 0);
        $s   = (float)($sgk[$i] ?? 0);
        $a   = trim((string)($acik[$i] ?? ''));

        $b = max(0, $b);
        $nma = max(0, $nma);
        $s = max(0, $s);
        $aDb = ($a === '' ? null : $a);

        if ($rid > 0) {
          // update
          $stUpd->execute([
            $ay, $pid,
            number_format($b, 2, '.', ''),
            number_format($nma, 2, '.', ''),
            number_format($s, 2, '.', ''),
            $aDb,
            $rid, $proje_id, $yil
          ]);
          $saved++;
        } else {
          // insert
          $stIns->execute([
            $proje_id, $yil, $ay, $pid,
            number_format($b, 2, '.', ''),
            number_format($nma, 2, '.', ''),
            number_format($s, 2, '.', ''),
            $aDb,
            (int)$_SESSION['id']
          ]);
          $saved++;
        }
      }

      $pdo->commit();
      header("Location: " . url('/personeller/proje_maas.php?proje_id='.$proje_id.'&yil='.$yil.'&ok=1'));
      exit;

    } catch (Throwable $e) {
      $pdo->rollBack();
      $err = "Hata: " . h($e->getMessage());
    }
  }
}

if (isset($_GET['ok'])) $ok = "Kaydedildi.";

// Liste (Proje + Yıl)
$rows = [];
if ($proje_id > 0) {
  $st = $pdo->prepare("
    SELECT pm.*, p.ad_soyad
    FROM proje_maas_kayitlari pm
    JOIN personeller p ON p.id = pm.personel_id
    WHERE pm.proje_id=? AND pm.yil=?
    ORDER BY pm.ay ASC, pm.id ASC
  ");
  $st->execute([$proje_id, $yil]);
  $rows = $st->fetchAll();
}

// DB toplamları (yıl bazlı)
$sum = ['brut'=>0,'net'=>0,'sgk'=>0];
if ($proje_id > 0) {
  $st = $pdo->prepare("SELECT SUM(brut_maas) brut, SUM(net_maas) net, SUM(sgk_primi) sgk
                       FROM proje_maas_kayitlari WHERE proje_id=? AND yil=?");
  $st->execute([$proje_id, $yil]);
  $r = $st->fetch() ?: [];
  $sum['brut'] = (float)($r['brut'] ?? 0);
  $sum['net']  = (float)($r['net'] ?? 0);
  $sum['sgk']  = (float)($r['sgk'] ?? 0);
}

// JS template: personel options
$personelOptionsHtml = '<option value="">Seç...</option>';
foreach ($personeller as $p) {
  $personelOptionsHtml .= '<option value="'.(int)$p['id'].'">'.h($p['ad_soyad']).'</option>';
}

$pageTitle = 'Proje Maaş';
include __DIR__ . '/../inc/header.php';
include __DIR__ . '/../inc/navbar.php';
?>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-3">
    <div>
      <h4 class="fw-bold mb-0"><i class="bi bi-cash-coin me-1"></i> Proje Maaş (Yıl Bazlı)</h4>
      <div class="text-secondary small">Ay satırda. Aynı personel+aynı ay için çoklu satır kaydı destekli.</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= h(url('/personeller/index.php')) ?>"><i class="bi bi-arrow-left me-1"></i> Personeller</a>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
  <?php if ($ok): ?><div class="alert alert-success"><?= h($ok) ?></div><?php endif; ?>

  <div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
      <form method="get" class="row g-3">
        <div class="col-12 col-lg-8">
          <label class="form-label">Proje</label>
          <select class="form-select" name="proje_id" required>
            <option value="">Seç...</option>
            <?php foreach ($projeler as $p): ?>
              <option value="<?= (int)$p['id'] ?>" <?= ($proje_id==(int)$p['id']?'selected':'') ?>>
                #<?= (int)$p['id'] ?> - <?= h($p['proje_adi']) ?> (<?= (int)$p['yil'] ?>)
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-6 col-lg-2">
          <label class="form-label">Yıl</label>
          <input class="form-control" type="number" name="yil" min="2000" max="2100" value="<?= (int)$yil ?>">
        </div>

        <div class="col-6 col-lg-2 d-grid">
          <label class="form-label d-none d-lg-block">&nbsp;</label>
          <button class="btn btn-primary"><i class="bi bi-search me-1"></i> Getir</button>
        </div>
      </form>
    </div>
  </div>

  <?php if ($proje_id > 0): ?>

    <div class="row g-3 mb-3">
      <div class="col-12 col-md-4">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="text-secondary small">Toplam Brüt (Canlı)</div>
          <div class="h4 fw-bold mb-0" id="tBrut"><?= number_format($sum['brut'],2,',','.') ?></div>
        </div></div>
      </div>
      <div class="col-12 col-md-4">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="text-secondary small">Toplam Net (Canlı)</div>
          <div class="h4 fw-bold mb-0" id="tNet"><?= number_format($sum['net'],2,',','.') ?></div>
        </div></div>
      </div>
      <div class="col-12 col-md-4">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="text-secondary small">Toplam SGK (Canlı)</div>
          <div class="h4 fw-bold mb-0" id="tSgk"><?= number_format($sum['sgk'],2,',','.') ?></div>
        </div></div>
      </div>
    </div>

    <div class="card shadow-sm border-0">
      <div class="card-header bg-white fw-semibold d-flex align-items-center justify-content-between flex-wrap gap-2">
        <span>Maaş Satırları (<?= (int)$yil ?>)</span>
        <?php if ($isAdmin): ?>
          <button type="button" class="btn btn-outline-primary btn-sm" id="btnAddRow">
            <i class="bi bi-plus-circle me-1"></i> Satır Ekle
          </button>
        <?php endif; ?>
      </div>

      <div class="card-body">
        <form method="post" id="salaryForm">
          <input type="hidden" name="proje_id" value="<?= (int)$proje_id ?>">
          <input type="hidden" name="yil" value="<?= (int)$yil ?>">
          <input type="hidden" name="deleted_ids" id="deleted_ids" value="">

          <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle text-center" id="salaryTable">
              <thead class="table-dark">
                <tr>
                  <th style="min-width:110px">Ay</th>
                  <th style="min-width:240px">Personel</th>
                  <th style="min-width:140px">Brüt</th>
                  <th style="min-width:140px">Net</th>
                  <th style="min-width:140px">SGK</th>
                  <th style="min-width:220px">Açıklama</th>
                  <th style="width:90px">İşlem</th>
                </tr>
              </thead>
              <tbody>
              <?php if (!$rows): ?>
                <tr class="no-rows"><td colspan="7" class="text-secondary">Henüz satır yok. Satır Ekle ile ekleyebilirsin.</td></tr>
              <?php else: foreach ($rows as $r): ?>
                <tr>
                  <td>
                    <input type="hidden" name="row_id[]" value="<?= (int)$r['id'] ?>">
                    <select class="form-select inp-ay" name="ay[]" required <?= (!$isAdmin?'disabled':'') ?>>
                      <?php for($m=1;$m<=12;$m++): ?>
                        <option value="<?= $m ?>" <?= ((int)$r['ay']===$m?'selected':'') ?>><?= $m ?></option>
                      <?php endfor; ?>
                    </select>
                  </td>
                  <td class="text-start">
                    <select class="form-select inp-personel" name="personel_id[]" required <?= (!$isAdmin?'disabled':'') ?>>
                      <option value="">Seç...</option>
                      <?php foreach ($personeller as $p): ?>
                        <option value="<?= (int)$p['id'] ?>" <?= ((int)$p['id']===(int)$r['personel_id']?'selected':'') ?>>
                          <?= h($p['ad_soyad']) ?>
                        </option>
                      <?php endforeach; ?>
                    </select>
                  </td>
                  <td><input class="form-control inp-num" type="number" step="0.01" min="0" name="brut_maas[]" value="<?= h((string)$r['brut_maas']) ?>" <?= (!$isAdmin?'readonly':'') ?>></td>
                  <td><input class="form-control inp-num" type="number" step="0.01" min="0" name="net_maas[]"  value="<?= h((string)$r['net_maas']) ?>"  <?= (!$isAdmin?'readonly':'') ?>></td>
                  <td><input class="form-control inp-num" type="number" step="0.01" min="0" name="sgk_primi[]" value="<?= h((string)$r['sgk_primi']) ?>" <?= (!$isAdmin?'readonly':'') ?>></td>
                  <td><input class="form-control" name="aciklama[]" value="<?= h((string)($r['aciklama'] ?? '')) ?>" <?= (!$isAdmin?'readonly':'') ?>></td>
                  <td>
                    <?php if ($isAdmin): ?>
                      <button type="button" class="btn btn-danger btn-sm btnDelRow" data-rowid="<?= (int)$r['id'] ?>"><i class="bi bi-trash"></i></button>
                    <?php else: ?>
                      <span class="text-secondary small">-</span>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; endif; ?>
              </tbody>
            </table>
          </div>

          <?php if ($isAdmin): ?>
            <button class="btn btn-success" type="submit"><i class="bi bi-save2 me-1"></i> Kaydet</button>
          <?php endif; ?>
        </form>
      </div>
    </div>

    <div class="card shadow-sm border-0 mt-3">
      <div class="card-header bg-white fw-semibold"><i class="bi bi-bar-chart me-1"></i> Ay Bazlı Toplamlar (Canlı)</div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered align-middle text-center mb-0" id="monthSummary">
            <thead class="table-light">
              <tr>
                <th>Ay</th><th>Brüt Toplam</th><th>Net Toplam</th><th>SGK Toplam</th>
              </tr>
            </thead>
            <tbody>
              <?php for($m=1;$m<=12;$m++): ?>
                <tr>
                  <td class="fw-semibold"><?= $m ?></td>
                  <td class="m-brut" data-ay="<?= $m ?>">0,00</td>
                  <td class="m-net"  data-ay="<?= $m ?>">0,00</td>
                  <td class="m-sgk"  data-ay="<?= $m ?>">0,00</td>
                </tr>
              <?php endfor; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <script>
      (function(){
        const btnAdd = document.getElementById('btnAddRow');
        const tbody  = document.querySelector('#salaryTable tbody');
        const deleted = document.getElementById('deleted_ids');

        const tBrut = document.getElementById('tBrut');
        const tNet  = document.getElementById('tNet');
        const tSgk  = document.getElementById('tSgk');

        const personelOptions = <?= json_encode($personelOptionsHtml, JSON_UNESCAPED_UNICODE) ?>;

        function fmtTR(n){
          n = Number(n || 0);
          return n.toLocaleString('tr-TR', {minimumFractionDigits:2, maximumFractionDigits:2});
        }
        function numVal(v){
          const x = parseFloat(String(v ?? '0').replace(',', '.'));
          return isFinite(x) ? x : 0;
        }
        function rowNum(tr, name){
          const el = tr.querySelector(`input[name="${name}[]"]`);
          return el ? numVal(el.value) : 0;
        }
        function removeNoRows(){
          const nr = tbody.querySelector('.no-rows');
          if(nr) nr.remove();
        }
        function markDeleted(id){
          if(!id || id<=0) return;
          const arr = deleted.value ? deleted.value.split(',').map(x=>x.trim()).filter(Boolean) : [];
          const s = String(id);
          if(!arr.includes(s)) arr.push(s);
          deleted.value = arr.join(',');
        }

        function recalc(){
          let brut=0, net=0, sgk=0;
          const mBrut = Array(13).fill(0);
          const mNet  = Array(13).fill(0);
          const mSgk  = Array(13).fill(0);

          tbody.querySelectorAll('tr').forEach(tr=>{
            if(tr.classList.contains('no-rows')) return;

            const aySel = tr.querySelector('.inp-ay');
            const ay = parseInt(aySel?.value || '0', 10);

            const b = rowNum(tr, 'brut_maas');
            const n = rowNum(tr, 'net_maas');
            const s = rowNum(tr, 'sgk_primi');

            brut += b; net += n; sgk += s;

            if(ay>=1 && ay<=12){
              mBrut[ay]+=b; mNet[ay]+=n; mSgk[ay]+=s;
            }
          });

          tBrut.textContent = fmtTR(brut);
          tNet.textContent  = fmtTR(net);
          tSgk.textContent  = fmtTR(sgk);

          for(let a=1;a<=12;a++){
            document.querySelector(`#monthSummary .m-brut[data-ay="${a}"]`).textContent = fmtTR(mBrut[a]);
            document.querySelector(`#monthSummary .m-net[data-ay="${a}"]`).textContent  = fmtTR(mNet[a]);
            document.querySelector(`#monthSummary .m-sgk[data-ay="${a}"]`).textContent  = fmtTR(mSgk[a]);
          }
        }

        function addRow(){
          removeNoRows();
          const tr = document.createElement('tr');
          tr.innerHTML = `
            <td>
              <input type="hidden" name="row_id[]" value="0">
              <select class="form-select inp-ay" name="ay[]" required>
                ${Array.from({length:12}, (_,i)=>`<option value="${i+1}">${i+1}</option>`).join('')}
              </select>
            </td>
            <td class="text-start">
              <select class="form-select inp-personel" name="personel_id[]" required>
                ${personelOptions}
              </select>
            </td>
            <td><input class="form-control inp-num" type="number" step="0.01" min="0" name="brut_maas[]" value="0"></td>
            <td><input class="form-control inp-num" type="number" step="0.01" min="0" name="net_maas[]" value="0"></td>
            <td><input class="form-control inp-num" type="number" step="0.01" min="0" name="sgk_primi[]" value="0"></td>
            <td><input class="form-control" name="aciklama[]" value=""></td>
            <td>
              <button type="button" class="btn btn-danger btn-sm btnDelRow" data-rowid="0">
                <i class="bi bi-trash"></i>
              </button>
            </td>
          `;
          tbody.appendChild(tr);
          recalc();
        }

        if (btnAdd) {
          btnAdd.addEventListener('click', function(e){
            e.preventDefault();
            e.stopPropagation();
            addRow();
          });
        }

        tbody.addEventListener('input', function(e){
          if (e.target.matches('.inp-num')) recalc();
        });
        tbody.addEventListener('change', function(e){
          if (e.target.matches('.inp-ay, .inp-personel')) recalc();
        });

        tbody.addEventListener('click', function(e){
          const btn = e.target.closest('.btnDelRow');
          if(!btn) return;

          const rid = parseInt(btn.getAttribute('data-rowid') || '0', 10);

          if (rid > 0) {
            if(!confirm('Bu satır silinsin mi?')) return;
            markDeleted(rid);
          }

          const tr = btn.closest('tr');
          if (tr) tr.remove();

          if (tbody.querySelectorAll('tr:not(.no-rows)').length === 0) {
            const nr = document.createElement('tr');
            nr.className = 'no-rows';
            nr.innerHTML = `<td colspan="7" class="text-secondary">Henüz satır yok. Satır Ekle ile ekleyebilirsin.</td>`;
            tbody.appendChild(nr);
          }

          recalc();
        });

        recalc();
      })();
    </script>

  <?php endif; ?>
</div>
<?php include __DIR__ . '/../inc/footer.php'; ?>
