<?php
// personeller/index.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../inc/permissions.php';

$uid = (int)($_SESSION['id'] ?? 0);
if (!has_module($pdo, $uid, $isAdmin, 'personeller')) {
  header("Location: " . url('/panel/index.php'));
  exit;
}

$err = $ok = '';

// Admin ekler
if ($isAdmin && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $ad = trim((string)($_POST['ad_soyad'] ?? ''));
  $tc = trim((string)($_POST['tc_no'] ?? ''));
  $aktif = (int)($_POST['aktif'] ?? 1);

  if ($ad === '') $err = "Ad Soyad zorunlu.";
  else {
    $stmt = $pdo->prepare("INSERT INTO personeller (ad_soyad, tc_no, aktif) VALUES (?,?,?)");
    $stmt->execute([$ad, ($tc===''?null:$tc), ($aktif?1:0)]);
    $ok = "Personel eklendi.";
  }
}

$rows = $pdo->query("SELECT * FROM personeller ORDER BY id DESC")->fetchAll();

$pageTitle = 'Personel & Maaş';
include __DIR__ . '/../inc/header.php';
include __DIR__ . '/../inc/navbar.php';
?>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-3">
    <div>
      <h4 class="fw-bold mb-0"><i class="bi bi-people me-1"></i> Personeller</h4>
      <div class="text-secondary small">Personel tanımla → Proje Maaş ekranında projeye bağla.</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= h(url('/personeller/proje_maas.php')) ?>">
      <i class="bi bi-cash-coin me-1"></i> Proje Maaş Girişi
    </a>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
  <?php if ($ok): ?><div class="alert alert-success"><?= h($ok) ?></div><?php endif; ?>

  <?php if ($isAdmin): ?>
  <div class="card shadow-sm border-0 mb-3">
    <div class="card-header bg-white fw-semibold"><i class="bi bi-person-plus me-1"></i> Yeni Personel</div>
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-12 col-md-6">
          <label class="form-label">Ad Soyad</label>
          <input class="form-control" name="ad_soyad" required>
        </div>
        <div class="col-12 col-md-4">
          <label class="form-label">TC No (opsiyonel)</label>
          <input class="form-control" name="tc_no">
        </div>
        <div class="col-12 col-md-2">
          <label class="form-label">Aktif</label>
          <select class="form-select" name="aktif">
            <option value="1" selected>1</option>
            <option value="0">0</option>
          </select>
        </div>
        <div class="col-12">
          <button class="btn btn-success"><i class="bi bi-save2 me-1"></i> Kaydet</button>
        </div>
      </form>
    </div>
  </div>
  <?php endif; ?>

  <div class="card shadow-sm border-0">
    <div class="card-header bg-white fw-semibold"><i class="bi bi-list-ul me-1"></i> Liste</div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-center">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>Ad Soyad</th>
              <th>TC</th>
              <th>Aktif</th>
              <th>İşlem</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$rows): ?>
            <tr><td colspan="5" class="text-secondary">Kayıt yok.</td></tr>
          <?php else: foreach ($rows as $r): ?>
            <tr>
              <td><?= (int)$r['id'] ?></td>
              <td class="text-start fw-semibold"><?= h($r['ad_soyad']) ?></td>
              <td><?= h($r['tc_no'] ?? '-') ?></td>
              <td><?= ((int)$r['aktif']===1?'1':'0') ?></td>
              <td>
                <?php if ($isAdmin): ?>
                  <a class="btn btn-danger btn-sm"
                     href="<?= h(url('/personeller/sil.php?id='.(int)$r['id'])) ?>"
                     onclick="return confirm('Personel silinsin mi? (Maaş kayıtları da silinir)');">
                    <i class="bi bi-trash"></i>
                  </a>
                <?php else: ?>
                  <span class="text-secondary small">Yetki yok</span>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../inc/footer.php'; ?>
