<?php
// panel/index.php (FULL - Yetkili Modül Görünümü)
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../inc/permissions.php';

$pageTitle = 'Panel';

// Kullanıcının modül yetkisi (projeler)
$uid = (int)($_SESSION['id'] ?? 0);
$canProjeler = has_module($pdo, $uid, $isAdmin, 'projeler');

include __DIR__ . '/../inc/header.php';
include __DIR__ . '/../inc/navbar.php';

// Projeleri sadece yetkiliyse çek
$projeler = [];
if ($canProjeler) {
  $projeler = $pdo->query("
    SELECT p.id, p.yil, p.proje_adi, p.created_at, k.ad_soyad
    FROM projeler p
    LEFT JOIN kullanicilar k ON k.id = p.olusturan_kullanici_id
    ORDER BY p.id DESC
  ")->fetchAll();
}
?>
<div class="container py-4">

  <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
    <div>
      <h4 class="fw-bold mb-0">📌 Projeler</h4>
      <div class="text-secondary small">
        “Proje Aç” → Proje Adı + Yıl gir → projeyi Aç → satır satır fatura kayıt gir.
      </div>
    </div>

    <?php if ($canProjeler): ?>
      <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#mdlProje">
        <i class="bi bi-folder-plus me-1"></i> Proje Aç
      </button>
    <?php endif; ?>
  </div>

  <?php if (!$canProjeler): ?>
    <div class="alert alert-warning">
      <i class="bi bi-shield-exclamation me-1"></i>
      Bu modülü görme yetkin yok. Admin’den “Projeler” modül yetkisi iste.
    </div>
  <?php else: ?>

    <div class="card shadow-sm border-0">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-hover align-middle text-center">
            <thead class="table-dark">
              <tr>
                <th>ID</th>
                <th>Yıl</th>
                <th>Proje Adı</th>
                <th>Oluşturan</th>
                <th>Tarih</th>
                <th>İşlem</th>
              </tr>
            </thead>
            <tbody>
            <?php if (!$projeler): ?>
              <tr><td colspan="6" class="text-secondary">Henüz proje yok.</td></tr>
            <?php else: foreach ($projeler as $p): ?>
              <tr>
                <td><?= (int)$p['id'] ?></td>
                <td><?= (int)$p['yil'] ?></td>
                <td class="text-start fw-semibold"><?= h($p['proje_adi']) ?></td>
                <td><?= h($p['ad_soyad'] ?? '-') ?></td>
                <td class="small text-secondary"><?= h($p['created_at']) ?></td>
                <td class="d-flex gap-2 justify-content-center flex-wrap">
                  <a class="btn btn-primary btn-sm" href="<?= h(url('/projeler/detay.php?id='.(int)$p['id'])) ?>">
                    <i class="bi bi-list-check me-1"></i> Aç
                  </a>

                  <?php if ($isAdmin): ?>
                    <a class="btn btn-danger btn-sm"
                       href="<?= h(url('/projeler/proje_sil.php?id='.(int)$p['id'])) ?>"
                       onclick="return confirm('Projeyi ve tüm kayıtlarını silmek istiyor musun?');">
                      <i class="bi bi-trash me-1"></i> Sil
                    </a>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Proje Aç Modal -->
    <div class="modal fade" id="mdlProje" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog">
        <form class="modal-content" method="post" action="<?= h(url('/projeler/olustur.php')) ?>">
          <div class="modal-header">
            <h5 class="modal-title">Proje Aç</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body">
            <div class="mb-3">
              <label class="form-label">Proje Adı</label>
              <input type="text" class="form-control" name="proje_adi" maxlength="160"
                     placeholder="Örn: Ocak 2026 Satış - Şube A"
                     required>
              <div class="form-text">Proje adını sen yazacaksın (otomatik yok).</div>
            </div>

            <div>
              <label class="form-label">Yıl</label>
              <input type="number" class="form-control" name="yil" min="2000" max="2100" value="<?= date('Y') ?>" required>
            </div>
          </div>

          <div class="modal-footer">
            <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Vazgeç</button>
            <button class="btn btn-success" type="submit">
              <i class="bi bi-check2 me-1"></i> Oluştur
            </button>
          </div>
        </form>
      </div>
    </div>

  <?php endif; ?>

</div>

<?php include __DIR__ . '/../inc/footer.php'; ?>
