<?php
// kullanicilar/index.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/guard.php';
require_once __DIR__ . '/../config/db.php';

if (!$isAdmin) { header("Location: " . url('/panel/index.php')); exit; }

$err = '';
$ok  = '';

// Kullanıcı Ekle
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $ad_soyad = trim((string)($_POST['ad_soyad'] ?? ''));
  $kadi     = trim((string)($_POST['kullanici_adi'] ?? ''));
  $sifre    = (string)($_POST['sifre'] ?? '');
  $rol      = (string)($_POST['rol'] ?? 'personel');
  $aktif    = (int)($_POST['aktif'] ?? 1);

  if ($ad_soyad === '' || $kadi === '' || $sifre === '') {
    $err = "Ad Soyad, Kullanıcı Adı ve Şifre zorunlu.";
  } elseif (!in_array($rol, ['admin','personel'], true)) {
    $err = "Rol hatalı.";
  } else {
    try {
      $stmt = $pdo->prepare("INSERT INTO kullanicilar (ad_soyad, kullanici_adi, sifre, rol, aktif) VALUES (?,?,?,?,?)");
      $stmt->execute([$ad_soyad, $kadi, md5($sifre), $rol, ($aktif ? 1 : 0)]);
      $ok = "Kullanıcı eklendi.";
    } catch (Throwable $e) {
      $err = "Hata: " . h($e->getMessage());
    }
  }
}

// Liste
$users = $pdo->query("SELECT id, ad_soyad, kullanici_adi, rol, aktif, created_at FROM kullanicilar ORDER BY id DESC")->fetchAll();

$pageTitle = 'Kullanıcılar';
include __DIR__ . '/../inc/header.php';
include __DIR__ . '/../inc/navbar.php';
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
    <div>
      <h4 class="fw-bold mb-0"><i class="bi bi-people me-1"></i> Kullanıcılar</h4>
      <div class="text-secondary small">Admin buradan kullanıcı açar (md5 şifre).</div>
    </div>
    <a class="btn btn-outline-secondary" href="<?= h(url('/panel/index.php')) ?>"><i class="bi bi-arrow-left me-1"></i> Panele Dön</a>
  </div>

  <?php if ($err): ?><div class="alert alert-danger"><i class="bi bi-x-circle me-1"></i><?= $err ?></div><?php endif; ?>
  <?php if ($ok): ?><div class="alert alert-success"><i class="bi bi-check-circle me-1"></i><?= h($ok) ?></div><?php endif; ?>

  <div class="card shadow-sm border-0 mb-3">
    <div class="card-header bg-white fw-semibold"><i class="bi bi-person-plus me-1"></i> Yeni Kullanıcı Ekle</div>
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-12 col-md-4">
          <label class="form-label">Ad Soyad</label>
          <input class="form-control" name="ad_soyad" required>
        </div>
        <div class="col-12 col-md-3">
          <label class="form-label">Kullanıcı Adı</label>
          <input class="form-control" name="kullanici_adi" required>
        </div>
        <div class="col-12 col-md-3">
          <label class="form-label">Şifre</label>
          <input class="form-control" type="password" name="sifre" required>
        </div>
        <div class="col-6 col-md-1">
          <label class="form-label">Rol</label>
          <select class="form-select" name="rol">
            <option value="personel">personel</option>
            <option value="admin">admin</option>
          </select>
        </div>
        <div class="col-6 col-md-1">
          <label class="form-label">Aktif</label>
          <select class="form-select" name="aktif">
            <option value="1" selected>1</option>
            <option value="0">0</option>
          </select>
        </div>

        <div class="col-12">
          <button class="btn btn-success"><i class="bi bi-save2 me-1"></i> Kaydet</button>
        </div>
      </form>
    </div>
  </div>

  <div class="card shadow-sm border-0">
    <div class="card-header bg-white fw-semibold"><i class="bi bi-list-ul me-1"></i> Kullanıcı Listesi</div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-center">
          <thead class="table-dark">
            <tr>
              <th>ID</th>
              <th>Ad Soyad</th>
              <th>Kullanıcı Adı</th>
              <th>Rol</th>
              <th>Aktif</th>
              <th>Tarih</th>
              <th>İşlem</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$users): ?>
            <tr><td colspan="7" class="text-secondary">Kullanıcı yok.</td></tr>
          <?php else: foreach ($users as $u): ?>
            <tr>
              <td><?= (int)$u['id'] ?></td>
              <td class="text-start fw-semibold"><?= h($u['ad_soyad']) ?></td>
              <td><?= h($u['kullanici_adi']) ?></td>
              <td><span class="badge <?= ($u['rol']==='admin'?'bg-danger':'bg-primary') ?>"><?= h($u['rol']) ?></span></td>
              <td><?= ((int)$u['aktif']===1 ? '1' : '0') ?></td>
              <td class="small text-secondary"><?= h($u['created_at']) ?></td>
              <td>
                <?php if ((int)$u['id'] === (int)$_SESSION['id']): ?>
                  <span class="text-secondary small">Kendin</span>
                <?php else: ?>
                  <a class="btn btn-danger btn-sm"
                     href="<?= h(url('/kullanicilar/sil.php?id='.(int)$u['id'])) ?>"
                     onclick="return confirm('Bu kullanıcı silinsin mi?');">
                    <i class="bi bi-trash"></i>
                  </a>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>
<?php include __DIR__ . '/../inc/footer.php'; ?>
