<?php
// inc/permissions.php
declare(strict_types=1);

function modules_list(): array {
  return [
    'projeler'    => 'Projeler',
    'personeller' => 'Personel & Maaş',
  ];
}

function has_module(PDO $pdo, int $userId, bool $isAdmin, string $moduleCode): bool {
  if ($isAdmin) return true;

  $q = $pdo->prepare("SELECT 1 FROM kullanici_yetkileri WHERE kullanici_id=? AND modul_kodu=? LIMIT 1");
  $q->execute([$userId, $moduleCode]);
  return (bool)$q->fetchColumn();
}
