<?php
// inc/navbar.php (FULL)
declare(strict_types=1);

require_once __DIR__ . '/permissions.php';
require_once __DIR__ . '/../config/db.php';

if (!function_exists('h')) {
  function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

$ad  = (string)($_SESSION['ad_soyad'] ?? '');
$rol = strtolower((string)($_SESSION['rol'] ?? 'personel'));
$uid = (int)($_SESSION['id'] ?? 0);

$isAdmin = ($rol === 'admin');
$badge   = $isAdmin ? 'bg-danger' : 'bg-primary';

// Modül yetkileri (admin için hepsi true gibi davranır, personel için DB’den kontrol)
$canProjeler    = has_module($pdo, $uid, $isAdmin, 'projeler');
$canPersoneller = has_module($pdo, $uid, $isAdmin, 'personeller');
$canRaporlar    = has_module($pdo, $uid, $isAdmin, 'raporlar');
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= h(url('/panel/index.php')) ?>">
      <i class="bi bi-calculator me-1"></i> mini muhasebe takip
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nv" aria-controls="nv" aria-expanded="false">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="nv">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">

        <!-- PERSONEL sadece Projeler + Personel & Maaş -->
        <?php if ($canProjeler): ?>
          <li class="nav-item">
            <a class="nav-link" href="<?= h(url('/panel/index.php')) ?>">
              <i class="bi bi-folder2-open me-1"></i> Projeler
            </a>
          </li>
        <?php endif; ?>

        <?php if ($canPersoneller): ?>
          <li class="nav-item">
            <a class="nav-link" href="<?= h(url('/personeller/index.php')) ?>">
              <i class="bi bi-people me-1"></i> Personel & Maaş
            </a>
          </li>
        <?php endif; ?>

        <!-- ✅ SADECE ADMIN’de görünsün -->
        <?php if ($isAdmin && $canRaporlar): ?>
          <li class="nav-item">
            <a class="nav-link" href="<?= h(url('/raporlar/proje_raporu.php')) ?>">
              <i class="bi bi-clipboard-data me-1"></i> Proje Raporu
            </a>
          </li>
        <?php endif; ?>

        <?php if ($isAdmin): ?>
          <li class="nav-item">
            <a class="nav-link" href="<?= h(url('/yetkiler/index.php')) ?>">
              <i class="bi bi-shield-lock me-1"></i> Yetkiler
            </a>
          </li>

          <li class="nav-item">
            <a class="nav-link" href="<?= h(url('/kullanicilar/index.php')) ?>">
              <i class="bi bi-people me-1"></i> Kullanıcılar
            </a>
          </li>
        <?php endif; ?>

      </ul>

      <div class="ms-auto d-flex align-items-center gap-2">
        <span class="text-white-50 small d-none d-lg-inline"><?= h($ad) ?></span>
        <span class="badge <?= $badge ?> text-uppercase"><?= h($rol) ?></span>

        <a class="btn btn-outline-light btn-sm" href="<?= h(url('/auth/logout.php')) ?>">
          <i class="bi bi-box-arrow-right me-1"></i> Çıkış
        </a>
      </div>
    </div>
  </div>
</nav>
