<?php
// inc/header.php
declare(strict_types=1);

$app = require __DIR__ . '/../config/app.php';

// header.php içinde h() TANIMLAMA! (guard.php zaten veriyor)
// Bazı sayfalarda guard include edilmemiş olabilir diye title kısmında direkt htmlspecialchars kullandım.
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>
    <?= htmlspecialchars(($app['app_name'] ?? 'Uygulama'), ENT_QUOTES, 'UTF-8') ?>
    <?= isset($pageTitle) ? ' | ' . htmlspecialchars((string)$pageTitle, ENT_QUOTES, 'UTF-8') : '' ?>
  </title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/app.css">
</head>
<body class="bg-light">
