<?php
// auth/login.php
declare(strict_types=1);

$app = require __DIR__ . '/../config/app.php';
session_name($app['session_name']);
session_start();

require_once __DIR__ . '/../config/db.php';

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$err = '';

if (isset($_SESSION['id'])) {
  header("Location: ../panel/index.php");
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['kullanici_adi'] ?? '');
  $p = (string)($_POST['sifre'] ?? '');

  if ($u === '' || $p === '') {
    $err = 'Kullanıcı adı ve şifre zorunlu.';
  } else {
    $stmt = $pdo->prepare("SELECT id, ad_soyad, kullanici_adi, sifre, rol, aktif FROM kullanicilar WHERE kullanici_adi=? LIMIT 1");
    $stmt->execute([$u]);
    $row = $stmt->fetch();

    if (!$row || (int)$row['aktif'] !== 1) {
      $err = 'Kullanıcı bulunamadı veya pasif.';
    } else {
      $ok = (md5($p) === (string)$row['sifre']);
      if (!$ok) {
        $err = 'Şifre hatalı.';
      } else {
        session_regenerate_id(true);
        $_SESSION['id'] = (int)$row['id'];
        $_SESSION['ad_soyad'] = (string)$row['ad_soyad'];
        $_SESSION['kullanici_adi'] = (string)$row['kullanici_adi'];
        $_SESSION['rol'] = (string)$row['rol'];
        header("Location: ../panel/index.php");
        exit;
      }
    }
  }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($app['app_name']) ?> | Giriş</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <style>
    body{min-height:100vh;background:linear-gradient(135deg,#0d6efd 0%,#20c997 100%);}
    .cardx{border:0;border-radius:18px;box-shadow:0 18px 45px rgba(0,0,0,.20);}
  </style>
</head>
<body class="d-flex align-items-center">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-md-7 col-lg-4">
        <div class="card cardx">
          <div class="card-body p-4">
            <div class="text-center mb-3">
              <div class="h3 fw-bold mb-0"><?= h($app['app_name']) ?></div>
              <div class="text-secondary small">Giriş yap</div>
            </div>
            <?php if ($err): ?>
              <div class="alert alert-danger"><i class="bi bi-exclamation-triangle me-1"></i><?= h($err) ?></div>
            <?php endif; ?>
            <form method="post" autocomplete="off">
              <div class="mb-3">
                <label class="form-label">Kullanıcı Adı</label>
                <input class="form-control" name="kullanici_adi" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Şifre</label>
                <input class="form-control" type="password" name="sifre" required>
              </div>
              <button class="btn btn-primary w-100 fw-semibold" type="submit">
                <i class="bi bi-box-arrow-in-right me-1"></i> Giriş
              </button>
            </form>
            <div class="text-center text-secondary small mt-3">admin / 1234</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
