<?php
// auth/guard.php
declare(strict_types=1);

$app = require __DIR__ . '/../config/app.php';
session_name($app['session_name']);
session_start();

if (!isset($_SESSION['id'])) {
  header("Location: " . (($app['base_path'] ?? '') . "/auth/login.php"));
  exit;
}

$rol = strtolower(trim((string)($_SESSION['rol'] ?? 'personel')));
$isAdmin = ($rol === 'admin');

if (!function_exists('h')) {
  function h($s): string {
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
  }
}

if (!function_exists('url')) {
  function url(string $path): string {
    $app = require __DIR__ . '/../config/app.php';
    $base = rtrim((string)($app['base_path'] ?? ''), '/');
    $path = '/' . ltrim($path, '/');
    return $base . $path;
  }
}
